//+------------------------------------------------------------------+
//|                                                        MyRSI.mq4 |
//|                                   Copyright (c) 2007, Toyolab FX |
//|                                         http://forex.toyolab.com |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2007, Toyolab FX"
#property link      "http://forex.toyolab.com"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 DodgerBlue
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_level1 30
#property indicator_level2 70

//wWobt@
double BufRSI[];
double BufPos[];
double BufNeg[];

//p[^[
extern int RSI_Period = 14;

//+------------------------------------------------------------------+
//| ֐                                                       |
//+------------------------------------------------------------------+
int init()
{
   //wWobt@̊蓖
   IndicatorBuffers(3);
   SetIndexBuffer(0,BufRSI);
   SetIndexBuffer(1,BufPos);
   SetIndexBuffer(2,BufNeg);

   //wWx̐ݒ
   string label = "RSI("+RSI_Period+")";
   IndicatorShortName(label);
   SetIndexLabel(0,label);

   return(0);
}

//+------------------------------------------------------------------+
//| wW֐                                                     |
//+------------------------------------------------------------------+
int start()
{
   int limit = Bars-IndicatorCounted();

   for(int i=limit-1; i>=0; i--)
   {
      BufPos[i] = 0.0; BufNeg[i] = 0.0; //wWobt@̏
      if(i == Bars-1) continue; //ŏ̃o[͌vZXLbv
      double rel = Close[i]-Close[i+1]; //Oo[Ƃ̍vZ
      if(rel > 0) BufPos[i] = rel; //vX̏ꍇ
      else BufNeg[i] = -rel;       //}CiX̏ꍇ
   }
   
   if(limit == Bars) limit -= RSI_Period-1;
   for(i=limit-1; i>=0; i--)
   {
      double positive = iMAOnArray(BufPos,0,RSI_Period,0,MODE_SMMA,i); //BufPosSMMAvZ
      double negative = iMAOnArray(BufNeg,0,RSI_Period,0,MODE_SMMA,i); //BufNegSMMAvZ
      if(negative == 0.0) BufRSI[i] = 0.0; //negative=0̏ꍇAvZłȂ̂łOɂ
      else BufRSI[i] = 100.0-100.0/(1+positive/negative); //RSǏvZ
   }

   return(0);
}
//+------------------------------------------------------------------+