# coding: Windows-31J

# \NX
class Stock
  attr_reader :code, :market, :unit, :prices

  def initialize(code, market, unit)
    @code = code
    @market = market
    @unit = unit
    @prices = []
    @price_hash = Hash.new
  end

  # 1̊
  def add_price(date, open, high, low, close, volume)
    @prices << {:date => date,
      :open => open,
      :high => high,
      :low  => low,
      :close => close,
      :volume => volume}
  end

  # f[^̂A̎
  # itA4{l̂ǂꂩAoj̔z𓾂
  def map_prices(price_name)
    @price_hash[price_name] ||= @prices.map {|price| price[price_name]}
  end

  # t̔z
  def dates
    map_prices(:date)
  end

  # nl̔z
  def open_prices
    map_prices(:open)
  end

  # l̔z
  def high_prices
    map_prices(:high)
  end

  # l̔z
  def low_prices
    map_prices(:low)
  end

  # Il̔z
  def close_prices
    map_prices(:close)
  end

  # o̔z
  def volumes
    map_prices(:volume)
  end
end
