# coding: Windows-31J

require "./lib/base"

# ^̒l̈ړρiATRjɊÂXgbvNX
# d|l
# ł́AnԂATRx{A
# ł́AnԂATRx{A
# Xgbvu
class AverageTrueRangeStop < Stop
  # :span  ATR̊
  # :ratio ATR̉{
  def initialize(params)
    @span = params[:span]
    @ratio = params[:ratio] || 1
  end

  def calculate_indicators
    @average_true_range = AverageTrueRange.new(@stock, span: @span).calculate
  end

  # d|lnATR(O)x{ɍsƂɃXgbv
  def stop_price_long(position, index)
    Tick.truncate(position.entry_price - range(index))
  end

  # d|lnATR(O)x{ɍsƂɃXgbv
  def stop_price_short(position, index)
    Tick.ceil(position.entry_price + range(index))
  end

  private
  def range(index)
    @average_true_range[index - 1] * @ratio
  end
end
