# coding: Windows-31J

require "./lib/trade"
require "./lib/array"
require "./lib/stats"
require "fileutils"
require "csv"

# ̋L^sNX
class Recorder
  attr_writer :record_dir

  def initialize(record_dir = nil)
    @record_dir = record_dir
  end

  # 1̎L^
  def record_a_stock(trades)
    code = trades[0].stock_code
    ensure_close("#{code}.csv") do
      file_name = "#{@record_dir}/#{code}.csv"
      CSV.open(file_name, "w") do |csv_file|
        csv_file << items_for_a_stock.values
        trades.each do |trade|
          one_trade = items_for_a_stock.keys.map do |attr|
            trade.send(attr) || "-"
          end
          csv_file << one_trade
        end
      end
    end
  end

  # Ƃ̓v̈ꗗ\̍쐬
  def record_stats_for_each_stock(results)
    ensure_close("_stats_for_each_stock.csv") do
      CSV.open("#{@record_dir}/_stats_for_each_stock.csv", "w") do |csv_file|
        csv_file << stats_items.values.unshift("R[h")
        results.each do |trades|
          csv_file << stats_array(trades).unshift(trades[0].stock_code)
        end
      end
    end
  end

  # ׂẴg[h̓v
  def record_stats(results)
    ensure_close("_stats.csv") do
      CSV.open("#{@record_dir}/_stats.csv", "w") do |csv_file|
        csv_file << stats_items.values
        csv_file << stats_array(results.flatten)
      end
    end
  end

  # ݒt@CRs[
  def record_setting(file_name)
    FileUtils.cp file_name, @record_dir + "/_setting.rb"
  end

  # ʕۑp̃tH_[
  def create_record_folder
    if Dir.exist? @record_dir
      puts "L^tH_ #{@record_dir} ͂łɑ݂܂B㏑܂H y/n"
      yes? {puts "㏑܂"}
    else
      puts "L^tH_ #{@record_dir} ݂͑܂BV܂H y/n"
      yes? {FileUtils.mkdir_p @record_dir}
    end
  end

  private
  def items_for_a_stock
    { :trade_type => "",
      :entry_date => "t",
      :entry_price => "l",
      :volume => "",
      :first_stop => "Xgbv",
      :exit_date => "ot",
      :exit_price => "ol",
      :profit => "v(~)",
      :r_multiple => "R{",
      :percentage_result => "%v",
      :length => ""}
  end

  def stats_items
    { :sum_profit => "v",
      :wins => "", :losses => "",
      :draws => "",
      :winning_percentage => "",
      :average_profit => "ϑv",
      :profit_factor => "PF",
      :sum_r => "R{", :average_r => "R{",
      :sum_percentage => "v",
      :average_percentage => "ϑv",
      :average_length => "ϊ"}
  end

  def stats_array(trades)
    stats = Stats.new(trades)
    stats_items.keys.map do |stats_name|
      stats.send(stats_name) || "-"
    end
  end

  def ensure_close(file_name)
    begin
      yield
    rescue Errno::EACCES
      puts "#{file_name} ̃vOŏ݋֎~ŊJĂ\܂B" +
        "t@CĂG^[L[ĂB"
      while $stdin.gets
        retry
      end
    end
  end

  def yes?
    while answer = $stdin.gets
      if answer =~ /^[yY]/
        yield
        break
      elsif answer =~ /^[nN]/
        puts "I܂"
        exit
      else
        puts "y i͂j n ijł"
      end
    end
  end
end
