// MultiSystem_EA.mq4
#property copyright "Copyright (c) 2012, Toyolab FX"
#property link      "http://forex.toyolab.com/"

// }CCu[
#define POSITIONS 2
#include <MyPosition.mqh>

// }WbNio[
int Magic = 20121400;
string EAname[POSITIONS] = {"MA2Cross1", "BBCross1"};

// Op[^
extern double Lots = 0.1;  // bg

// eNjJwW̐ݒiVXeOj
#define MaxBars 3
double FastMA[MaxBars];        // Zړϗpz
double SlowMA[MaxBars];        // ړϗpz
extern int FastMAPeriod = 20;  // Zړς̊
extern int SlowMAPeriod = 40;  // ړς̊

// eNjJwW̐ݒiVXePj
double BB_U[MaxBars];      // ʃCp̔z
double BB_L[MaxBars];      // ʃCp̔z
extern int BBPeriod = 20;  // {W[oh̊
extern int BBDev = 2;      // W΍̔{

// eNjJwW̍XV
void RefreshIndicators()
{
   for(int i=0; i<MaxBars; i++)
   {
      FastMA[i] = iMA(NULL, 0, FastMAPeriod, 0, MODE_SMA, PRICE_CLOSE, i);
      SlowMA[i] = iMA(NULL, 0, SlowMAPeriod, 0, MODE_SMA, PRICE_CLOSE, i);
      BB_U[i] = iBands(NULL, 0, BBPeriod, BBDev, 0, PRICE_CLOSE, MODE_UPPER, i);
      BB_L[i] = iBands(NULL, 0, BBPeriod, BBDev, 0, PRICE_CLOSE, MODE_LOWER, i);
   }
}

// wWPwWQ㔲
bool CrossUp(double& ind1[], double& ind2[], int shift)
{
   return(ind1[shift+1] <= ind2[shift+1] && ind1[shift] > ind2[shift]);
}

// wWPwWQ
bool CrossDown(double& ind1[], double& ind2[], int shift)
{
   return(ind1[shift+1] >= ind2[shift+1] && ind1[shift] < ind2[shift]);
}

// IlwW㔲
bool CrossUpClose(double& ind2[], int shift)
{
   return(Close[shift+1] <= ind2[shift+1] && Close[shift] > ind2[shift]);
}

// IlwW
bool CrossDownClose(double& ind2[], int shift)
{
   return(Close[shift+1] >= ind2[shift+1] && Close[shift] < ind2[shift]);
}

// Gg[֐
int EntrySignal(int pos_id)
{
   // I[v|WV̌vZ
   double pos = MyOrderOpenLots(pos_id);

   int ret = 0;
   switch(pos_id)
   {
      case 0:  // VXeO
      // VOi
      if(pos <= 0 && CrossUp(FastMA, SlowMA, 1)) ret = 1;
      // VOi
      if(pos >= 0 && CrossDown(FastMA, SlowMA, 1)) ret = -1;
      break;

      case 1:  // VXeP
      // VOi
      if(pos <= 0 && CrossDownClose(BB_L, 1)) ret = 1;
      // VOi
      if(pos >= 0 && CrossUpClose(BB_U, 1)) ret = -1;
      break;
   }
   return(ret);
}

// ֐
int init()
{
   // |WV̏
   MyInitPosition(Magic);
   return(0);
}

// eBbNs֐
int start()
{
   // eNjJwW̍XV   
   RefreshIndicators();
   
   // |WV̍XV
   MyCheckPosition();

   for(int i=0; i<POSITIONS; i++)
   {
      // Gg[VOi
      int sig_entry = EntrySignal(i);

      // 
      if(sig_entry > 0)
      {
         MyOrderClose(i);
         MyOrderSend(i, OP_BUY, Lots, 0, 0, 0, EAname[i]);
      }
      // 蒍
      if(sig_entry < 0)
      {
         MyOrderClose(i);
         MyOrderSend(i, OP_SELL, Lots, 0, 0, 0, EAname[i]);
      }
   }
   return(0);
}

