// MA2Cross1_EA.mq4
#property copyright "Copyright (c) 2012, Toyolab FX"
#property link      "http://forex.toyolab.com/"

// }CCu[
#define POSITIONS 1
#include <MyPosition.mqh>

// }WbNio[
int Magic = 20120300;
string EAname = "MA2Cross1_EA";

// Op[^
extern double Lots = 0.1;  // bg

// eNjJwW̐ݒ
#define MaxBars 3
double FastMA[MaxBars];        // Zړϗpz
double SlowMA[MaxBars];        // ړϗpz
extern int FastMAPeriod = 20;  // Zړς̊
extern int SlowMAPeriod = 40;  // ړς̊

// eNjJwW̍XV
void RefreshIndicators()
{
   for(int i=0; i<MaxBars; i++)
   {
      FastMA[i] = iMA(NULL, 0, FastMAPeriod, 0, MODE_SMA, PRICE_CLOSE, i);
      SlowMA[i] = iMA(NULL, 0, SlowMAPeriod, 0, MODE_SMA, PRICE_CLOSE, i);
   }
}

// wWPwWQ㔲
bool CrossUp(double& ind1[], double& ind2[], int shift)
{
   return(ind1[shift+1] <= ind2[shift+1] && ind1[shift] > ind2[shift]);
}

// wWPwWQ
bool CrossDown(double& ind1[], double& ind2[], int shift)
{
   return(ind1[shift+1] >= ind2[shift+1] && ind1[shift] < ind2[shift]);
}

// Gg[֐
int EntrySignal(int pos_id)
{
   // I[v|WV̌vZ
   double pos = MyOrderOpenLots(pos_id);

   int ret = 0;
   // VOi
   if(pos <= 0 && CrossUp(FastMA, SlowMA, 1)) ret = 1;
   // VOi
   if(pos >= 0 && CrossDown(FastMA, SlowMA, 1)) ret = -1;
   return(ret);
}

// ֐
int init()
{
   // |WV̏
   MyInitPosition(Magic);
   return(0);
}

// eBbNs֐
int start()
{
   // eNjJwW̍XV   
   RefreshIndicators();
   
   // |WV̍XV
   MyCheckPosition();

   // Gg[VOi
   int sig_entry = EntrySignal(0);

   // 
   if(sig_entry > 0)
   {
      MyOrderClose(0);
      MyOrderSend(0, OP_BUY, Lots, 0, 0, 0, EAname);
   }
   // 蒍
   if(sig_entry < 0)
   {
      MyOrderClose(0);
      MyOrderSend(0, OP_SELL, Lots, 0, 0, 0, EAname);
   }
   return(0);
}

